//=============================================================================
// Danish Armor2 powerup.
//=============================================================================
class DanishArmor2 extends Armor2;

#exec TEXTURE IMPORT NAME=DanishArmor FILE=E:\UnrealTournament\DanishInventory\Textures\DanishArmor.PCX LODSET=2
#exec AUDIO IMPORT FILE="E:\UnrealTournament\DanishInventory\Sounds\DanishArmorSnd.WAV" NAME="DanishArmorSnd"

function bool HandlePickupQuery( inventory Item )
{
	local inventory S;

	if ( item.class == class )
	{
		S = Pawn(Owner).FindInventoryType(class'UT_Shieldbelt');
		if (  S==None )
		{
			if ( Charge<Item.Charge )
				Charge = Item.Charge;
		}
		else
			Charge = Clamp(S.Default.Charge - S.Charge, Charge, Item.Charge );
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		if ( PickupMessageClass == None )
			Pawn(Owner).ClientMessage(PickupMessage, 'Pickup');
		else
			Pawn(Owner).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
		Item.PlaySound (PickupSound,,2.0);
		Item.SetReSpawn();
		return true;
	}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy, S;

	Copy = Super.SpawnCopy(Other);
	S = Other.FindInventoryType(class'UT_Shieldbelt');
	if ( S != None )
	{
		Copy.Charge = Min(Copy.Charge, S.Default.Charge - S.Charge);
		if ( Copy.Charge <= 0 )
		{
			S.Charge -= 1;
			Copy.Charge = 1;
		}
	}
	return Copy;
}

defaultproperties
{
     PickupMessage="You picked up the Danish Armor, it will protect you."
     PickupSound=Sound'DanishInventory.DanishArmorSnd'
     MultiSkins(1)=Texture'DanishInventory.DanishArmor'
}
